#include "bdtypes.h"
#include "bdglobal.h"
#include "bdfunc.h"

#ifdef WIN32

#include <windows.h>

static DWORD bSetup;

// Function name	: DialogProc
// Description	    : 
// Return type		: BOOL CALLBACK 
// Argument         :  HWND hWnd
// Argument         : UINT message
// Argument         : WPARAM wParam
// Argument         : LPARAM lParam
BOOL CALLBACK DialogProc( HWND hWnd, UINT message, 
						 WPARAM wParam, LPARAM lParam )
{
	static int Capture = 0;

	switch(message){
	case WM_KEYDOWN:
        switch( wParam ){
		case VK_ESCAPE:
			SendMessage(hWnd, WM_CLOSE, 0, 0);
			break;
		case VK_F1:
			Save_Screen();
			break;
		}
		break;
	case WM_COMMAND:
		if (HIWORD(wParam)!=BN_CLICKED)
			break;
		switch(LOWORD(wParam))
		{
		case IDC_SOUNDDOWN:
			if ((g_demostate.NoSoundMode==false)&&(g_demostate.playHandle)&&(g_demostate.MidasVolume>0))
			{
				g_demostate.MidasVolume -= 2;
				MIDASsetMusicVolume(g_demostate.playHandle, g_demostate.MidasVolume);
			}
			break;
		case IDC_SOUNDUP:
			if ((g_demostate.NoSoundMode==false)&&(g_demostate.playHandle)&&(g_demostate. MidasVolume<64))
			{
				g_demostate.MidasVolume += 2;
				MIDASsetMusicVolume(g_demostate.playHandle, g_demostate.MidasVolume);
			}
			break;
		}
		break;
	case WM_ACTIVATE:
		if ((g_demostate.AltTabQuit==0)||(LOWORD(wParam)!=WA_INACTIVE))
			break;
	case WM_CLOSE:
		//Save_Screen();
		g_demostate.bDemoLoop = FALSE;
		break;
	}

	return 0;
}


// Function name	: InitWindow
// Description	    : 
// Return type		: BOOL 
// Argument         : HINSTANCE hInstance
BOOL InitWindow(HINSTANCE hInstance)
{
	g_demostate.hwnd = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_BIG_DIALOG), NULL, (int (__stdcall *)(void))DialogProc);

	if (!g_demostate.hwnd) 
		return false;
	ShowWindow(g_demostate.hwnd,SW_SHOWDEFAULT);
	UpdateWindow(g_demostate.hwnd);

	return true;
}

DWORD Tick()
{
  return GetTickCount();
}

BOOL CALLBACK SetupProc( HWND hWnd, UINT message, 
						 WPARAM wParam, LPARAM lParam )
{
	HWND hControl;
	static BOOL bButton = FALSE;

	switch(message){
	case WM_COMMAND:
		if ((HIWORD(wParam)==BN_CLICKED)&&(LOWORD(wParam)==IDC_BUTTON))
		{
			bButton = TRUE;
			SendMessage(hWnd, WM_CLOSE, 0,0);
			return 1;
		}
		break;
	case WM_CLOSE:
		if (bButton==FALSE)
			exit(0);

		// priority
		hControl = GetDlgItem(hWnd, IDC_HIGH);
		if (SendMessage(hControl, BM_GETCHECK, 0,0)==BST_CHECKED)
			g_demostate.dwPriority = HIGH_PRIORITY_CLASS;
		else
		{
			hControl = GetDlgItem(hWnd, IDC_NORMAL);
			if (SendMessage(hControl, BM_GETCHECK, 0,0)==BST_CHECKED)
				g_demostate.dwPriority = NORMAL_PRIORITY_CLASS;
			else
			{
				hControl = GetDlgItem(hWnd, IDC_REALTIME);
				if (SendMessage(hControl, BM_GETCHECK, 0,0)==BST_CHECKED)
					g_demostate.dwPriority = REALTIME_PRIORITY_CLASS;
				else
				{
					g_demostate.dwPriority = IDLE_PRIORITY_CLASS;
				}
			}
		}

		hControl = GetDlgItem(hWnd, IDC_ALTTAB);
		if (SendMessage(hControl, BM_GETCHECK, 0,0)==BST_CHECKED)
			g_demostate.AltTabQuit = TRUE;
		else
			g_demostate.AltTabQuit = FALSE;

		hControl = GetDlgItem(hWnd, IDC_NOSOUND);
		if (SendMessage(hControl, BM_GETCHECK, 0,0)==BST_CHECKED)
			g_demostate.NoSoundMode = TRUE;
		else
			g_demostate.NoSoundMode = FALSE;		

		hControl = GetDlgItem(hWnd, IDC_DSOUND);
		if (SendMessage(hControl, BM_GETCHECK, 0,0)==BST_CHECKED)
			g_demostate.DirectSound = TRUE;
		else
			g_demostate.DirectSound = FALSE;		

		hControl = GetDlgItem(hWnd, IDC_VIDEO);
		if (SendMessage(hControl, BM_GETCHECK, 0,0)==BST_CHECKED)
			g_demostate.VideoFlo = TRUE;
		else
			g_demostate.VideoFlo = FALSE;		
		
		bSetup = FALSE;
		DestroyWindow(hWnd);
		return 1;
	}

	return 0;
}

void Setup(HINSTANCE hInstance)
{
	HWND hwnd, hCtrl;
	MSG msg;


	bSetup = TRUE;
	hwnd = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_SETUP), NULL, (int (__stdcall *)(void))SetupProc);

	hCtrl = GetDlgItem(hwnd, IDC_HIGH);
	SendMessage(hCtrl, BM_SETCHECK, BST_CHECKED, 0);

	hCtrl = GetDlgItem(hwnd, IDC_ALTTAB);
	SendMessage(hCtrl, BM_SETCHECK, BST_CHECKED, 0);

	ShowWindow(hwnd, SW_SHOWDEFAULT);
	UpdateWindow(hwnd);
	while(bSetup&&GetMessage(&msg, hwnd, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}

// Linux
#else

#include <sys/time.h>

void Setup()
{

}

void repSIGINT()
{
  if (g_demostate.bDemoLoop){
    printf("Argh argh, SIGINT !!!\n");
    g_demostate.bDemoLoop = FALSE;
  }
}

DWORD Tick()
{
  struct timeval tv;
  struct timezone tz;
  DWORD ret;

  gettimeofday(&tv, &tz);

  ret = tv.tv_sec * 1000 + tv.tv_usec/1000;

  return ret;
}

#endif
